// DiskInfoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DiskInfo.h"
#include "DiskInfoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


#include "InformacjeODysku.h"

// CDiskInfoDlg dialog




CDiskInfoDlg::CDiskInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDiskInfoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDiskInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, listBox1);
}

BEGIN_MESSAGE_MAP(CDiskInfoDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CDiskInfoDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDiskInfoDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDiskInfoDlg::OnBnClickedButton3)
END_MESSAGE_MAP()


// CDiskInfoDlg message handlers

BOOL CDiskInfoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	const int BwGB=1024*1024*1024; //ilosc bajtow w GB

	for(char litera = 'c'; litera <= 'z'; litera++)
	{
		DaneODysku informacjeODysku;
		PobierzInformacjeODysku(litera, informacjeODysku);
		if (informacjeODysku.czyDyskDostepny)
		{
			double calkowitaPrzestrzenGB = ROUND1((double)informacjeODysku.calkowitaPrzestrzen/BwGB);
			double wolnaPrzestrzenGB = ROUND1((double)informacjeODysku.wolnaPrzestrzen/BwGB);
			double zajetaPrzestrzenGB = ROUND1((double)informacjeODysku.zajetaPrzestrzen/BwGB);
         
			CString temp;
         
			temp.AppendFormat(L"%c: %s, zajte miejsce: %.2lf/%.2lf/%.2lf GB, (%d %%) nazwa woluminu: %s, SN: %I64d, FAT: %s", 
				informacjeODysku.literaDysku, informacjeODysku.typDyskuOpis, 
				zajetaPrzestrzenGB, wolnaPrzestrzenGB, 
				calkowitaPrzestrzenGB, 100 - informacjeODysku.wolnaPrzestrzenProcenty,
				informacjeODysku.nazwaDysku, (unsigned __int64)informacjeODysku.numerSeryjnyDysku,
				informacjeODysku.nazwaFAT);
            
			listBox1.AddString(temp);
		}
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDiskInfoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDiskInfoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void WyswietlInformacje(char literaDysku)
{
	//DaneODysku informacjeODysku;
	//PobierzInformacjeODysku(literaDysku,informacjeODysku);
	InformacjeODysku informacjeODysku(literaDysku);		

	if(!informacjeODysku.czyDyskDostepny) 
	{
		MessageBox(NULL,L"Dysk nie jest dostpny",L"Ostrzeenie",MB_ICONWARNING);
		return;
	}
	CString komunikat;
	komunikat.Format(L"Informacje o dysku\nNazwa: %s\nTyp dysku: %s\nTyp FAT: %s\nWielko dysku: %.2f GB\nIlo wolnego miejsca: %.0f %%",
		informacjeODysku.nazwaDysku,
		informacjeODysku.typDyskuOpis,
		informacjeODysku.nazwaFAT,
		informacjeODysku.calkowitaPrzestrzen/1024.0/1024.0/1024.0,
		100*informacjeODysku.wolnaPrzestrzenUlamek
		);
	MessageBox(NULL,komunikat,L"Informacja o dysku",MB_OK);
}

void CDiskInfoDlg::OnBnClickedButton1()
{
	WyswietlInformacje('c');
}

void CDiskInfoDlg::OnBnClickedButton2()
{
	WyswietlInformacje('d');
}

void CDiskInfoDlg::OnBnClickedButton3()
{
	WyswietlInformacje('z');
}
